import os, time
import threading, Queue
from random import randint
import emant

class WorkerThread(threading.Thread):
    """ Callback function is passed thru Queue in dir_q.
        Output thru Callback function
        Ask the thread to stop by calling its join() method.
    """
    def __init__(self, dir_q):
        super(WorkerThread, self).__init__()
        self.dir_q = dir_q
        self.stoprequest = threading.Event()

    def run(self):
        # change mac address
        cb_fn = self.dir_q.get()
        try:
            m = emant.Emant300()
            m.Open("00:06:66:00:A1:D8")
            print m.HwId()
            print "connected!"
            while not self.stoprequest.isSet():
                volt, binval = m.ReadAnalog(emant.Emant300.AIN0,emant.Emant300.COM)
                lux = 1333 * volt
                cb_fn(int(lux),"Connected")
                time.sleep(0.1)
            m.Close()
        except:
            print "simulation!"
            while not self.stoprequest.isSet():
                cb_fn(randint(20,90),"Simulation")
                time.sleep(0.1)
                
        cb_fn(0,"Disconnected")
        print "disconnected!"

    def join(self, timeout=None):
        self.stoprequest.set()
        super(WorkerThread, self).join(timeout)


class getData:
    def __init__(self):
        self.val = 0
        self.stat = "Disconnected"
        self.conn = False
        self.q = None
        self.pool = None

    def cb(self, m, n):
        self.val = m
        self.stat = n

    def cmd(self, s):
        if (s=="conn"):
            if (not self.conn):
                self.q = Queue.Queue()
                self.pool = WorkerThread(self.q)
                self.pool.start()
                self.q.put(self.cb)
                self.stat = "Connecting ..."
                self.conn = True
            else:
                self.pool.join()
                self.q = None
                self.pool = None
                self.stat = "Disconnected"
                self.conn = False
        return(self.val,self.stat)


def main():
    a = getData()
    c = a.cmd("conn")
    print c
    for i in range(1,10):
        c = a.cmd("read")
        print c
        time.sleep(1)
    c = a.cmd("conn")
    print c
    for i in range(1,5):
        c = a.cmd("read")
        print c
        time.sleep(1)


if __name__ == '__main__':
    main()
